% Author Mamata Naik
% Department of Bioengineering, University of Strathclyde
% Date June 2007
%--------------------------------------------------------------------------

%  This Matlab code is written in order to achieve Image region grwoing
%  Region growing consists of the following steps
% 1.     Choose the seed (pixel) for each region.
% 2.	 Check the neighbouring pixels and add them to the region if they are similar to the seeds.
% 3.	 Repeat step two for each of the newly added pixels; stop if no more pixels can be added
%--------------------------------------------------------------------------

%  % Some of the important matlab functions used are
% 1.imread, 2.bwmorph, 3.abs 4.false
%--------------------------------------------------------------------------


inputim=imread('image.jpg');
inputim=rgb2gray(inputim);
im=double(inputim);
shigh=255;
t=65;  
if numel(s)==1
    si=im==shigh;
    s1=s;
else
    si=bwmorph(shigh,'shrink',Inf);           %bwmorph  Perform morphological operations on binary image.
                                          %BW2 = bwmorph(BW1,OPERATION) applies a specific
                                          % morphological operation to the binary image BW1.  
 
                                           %B W2 = bwmorph(BW1,OPERATION,N) applies the operation N
                                            %times.  N can be Inf, in which case the operation is repeated  until the image no longer changes.      
    j=find(si);                              %  I = find(X) returns the indices of the vector X that are non-zero. For example, I = find(A>100), returns the indices
                                              %of A where A is greater than 100. See RELOP.
    s1=im(j);              
end
ti=false(size(im));                          %false is short-hand for logical(0). false(SIZE(A)) is the same size as A and all logical zeros.
for k=1:length(s1)                           %length(X) returns the length of vector X.  It is equivalent to MAX(SIZE(X)) for non-empty arrays and 0 for empty ones.
   sv=s1(k);
   shigh=abs(im-sv)<=t;
   ti=ti|shigh;
end
[sim nrg]=bwlabel(imreconstruct(si,ti));
figure,imshow(inputim),title('Original Image');
figure,imshow(sim),title('Segmented Image - Region Growing');
display('No: of regions');
nrg
end;